<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * ltiprocessor import utility form.
 *
 * @package    local_ltiprocessor
 * @copyright  2016 Hurix Systems {@link http://hurix.com}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir . '/formslib.php');

class local_ltiprocessor_mod_form extends moodleform {

    // Define the form
    function definition() {
        global $CFG, $DB, $USER;

        $mform = $this->_form;

        /* $publishers = get_config('local_ltiprocessor', 'inactivity');
          $publishersarray = explode(',', $publishers);
          $publishersarray1 = array_merge(array('' => 'Choose...'),$publishersarray);

          $mform->addElement('header', 'settingsheader', get_string('upload')); */


        $courses = get_courses();
        $coursearray = array('' => 'Choose...');

        if ($courses) {
            foreach ($courses as $course) {
                $coursearray[$course->id] = format_string($course->fullname);
            }
        }

        $tooltypes = array('' => 'Choose...');

        $tooltypesql = "SELECT * FROM {$CFG->prefix}lti_types WHERE coursevisible = 1";
        if ($records = $DB->get_records_sql($tooltypesql)) {
            foreach ($records as $record) {
                $tooltypes[$record->id] = format_string($record->name);
            }
        }

        $select = $mform->addElement('select', 'courseids', get_string('selectcourses', 'local_ltiprocessor'), $coursearray);
        $mform->setType('courseids', PARAM_NOTAGS);
        $mform->addRule('courseids', get_string('required'), 'required', null, 'client');
        $select->setMultiple(true);

        $mform->addElement('select', 'tooltypes', get_string('tooltypes', 'local_ltiprocessor'), $tooltypes);
        $mform->setType('tooltypes', PARAM_NOTAGS);
        $mform->addRule('tooltypes', get_string('required'), 'required', null, 'client');

        $mform->addElement('text', 'activityname', get_string('activityname', 'local_ltiprocessor'));
        $mform->setType('activityname', PARAM_NOTAGS);
        $mform->addRule('activityname', get_string('required'), 'required', null, 'client');

        //$mform->addElement('hidden', 'page', $page);
        $this->add_action_buttons(true, get_string('submit'));
    }

}
