<?php

function local_ltiprocessor_create_lti($courseid, $ltiname, $typeid) {
    global $CFG, $DB, $USER;

    $version = $DB->get_field_sql("SELECT VALUE FROM {$CFG->prefix}config WHERE NAME = 'version'");
    require_once($CFG->dirroot . '/mod/lti/locallib.php');

    if ($version > '2014051215') {
        $lti->name = $ltiname;
        $lti->course = $courseid;
        $lti->timecreated = time();
        $lti->timemodified = $lti->timecreated;
        $lti->servicesalt = uniqid('', true);
        $lti->visible = 1;
        $lti->typeid = $typeid;
        $lti->introformat = 1;
        $lti->modulename = 'lti';
        $lti->showtitlelaunch = 1;
        $lti->section = 0;
        $lti->grade = 100;
        $lti->toolurl = '';

        lti_force_type_config_settings($lti, lti_get_type_config_by_instance($lti));

        if (empty($lti->typeid) && isset($lti->urlmatchedtypeid)) {
            $lti->typeid = $lti->urlmatchedtypeid;
        }

        if (!isset($lti->instructorchoiceacceptgrades) || $lti->instructorchoiceacceptgrades != LTI_SETTING_ALWAYS) {
            // The instance does not accept grades back from the provider, so set to "No grade" value 0.
            $lti->grade = 0;
        }

        if ($lti->id = $DB->insert_record('lti', $lti)) {
            if (isset($lti->instructorchoiceacceptgrades) && $lti->instructorchoiceacceptgrades == LTI_SETTING_ALWAYS) {
                if (!isset($lti->cmidnumber)) {
                    $lti->cmidnumber = '';
                }

                lti_grade_item_update($lti);
            }

            $modid = $DB->get_field_sql("SELECT id FROM {modules} WHERE name like 'lti'");

            $data = new stdClass();
            $data->course = $courseid;
            $data->module = $modid;
            $data->instance = $lti->id;
            $data->section = $DB->get_field('course_sections', 'id', array('course' => $courseid, 'section' => 1, 'visible' => 1));
            $data->added = time();

            if ($cmid = $DB->insert_record('course_modules', $data)) {
                $DB->execute("UPDATE {$CFG->prefix}course_sections SET sequence = CONCAT(sequence, ',$cmid') WHERE course = ? AND section = 0", array($courseid));
            }
        }
    } else {
        $lti->name = $ltiname;
        $lti->course = $courseid;
        $lti->timecreated = time();
        $lti->timemodified = $lti->timecreated;
        $lti->servicesalt = uniqid('', true);
        $lti->visible = 1;
        $lti->typeid = $typeid;
        $lti->introformat = 1;
        $lti->modulename = 'lti';
        $lti->showtitlelaunch = 1;
        $lti->section = 0;
        $lti->grade = 100;
        $lti->toolurl = '';

        if ($lti->id = $DB->insert_record('lti', $lti)) {
            if ($lti->instructorchoiceacceptgrades == LTI_SETTING_ALWAYS) {
                if (!isset($lti->cmidnumber)) {
                    $lti->cmidnumber = '';
                }

                lti_grade_item_update($lti);
            }

            $modid = $DB->get_field_sql("SELECT id FROM {modules} WHERE name like 'lti'");

            $data = new stdClass();
            $data->course = $courseid;
            $data->module = $modid;
            $data->instance = $lti->id;
            $data->section = $DB->get_field('course_sections', 'id', array('course' => $courseid, 'section' => 1, 'visible' => 1));
            $data->added = time();

            if ($cmid = $DB->insert_record('course_modules', $data)) {
                $DB->execute("UPDATE {$CFG->prefix}course_sections SET sequence = CONCAT(sequence, ',$cmid') WHERE course = ? AND section = 0", array($courseid));
            }
        }
    }

    // Trash modinfo.
    rebuild_course_cache($courseid, true);

    return $lti->id;
}

function local_ltiprocessor_update_lti($courseid, $ltiname, $typeid, $ltiid) {
    global $CFG, $DB, $USER;

    require_once($CFG->dirroot . '/mod/lti/locallib.php');
    $version = $DB->get_field_sql("SELECT VALUE FROM {$CFG->prefix}config WHERE NAME = 'version'");

    if ($version > '2014051215') {
        if ($lti = $DB->get_record('lti', array('id' => $ltiid))) {
            $lti->name = $ltiname;
            $lti->course = $courseid;
            $lti->toolurl = '';
            $lti->typeid = $typeid;
            $lti->timemodified = time();

            lti_force_type_config_settings($lti, lti_get_type_config_by_instance($lti));

            if (isset($lti->instructorchoiceacceptgrades) && $lti->instructorchoiceacceptgrades == LTI_SETTING_ALWAYS) {
                lti_grade_item_update($lti);
            } else {
                // Instance is no longer accepting grades from Provider, set grade to "No grade" value 0.
                $lti->grade = 0;
                $lti->instructorchoiceacceptgrades = 0;

                lti_grade_item_delete($lti);
            }

            if ($lti->typeid == 0 && isset($lti->urlmatchedtypeid)) {
                $lti->typeid = $lti->urlmatchedtypeid;
            }

            $DB->update_record('lti', $lti);
        }
    } else {
        if ($lti = $DB->get_record('lti', array('id' => $ltiid))) {
            $lti->name = $ltiname;
            $lti->course = $courseid;
            $lti->toolurl = '';
            $lti->typeid = $typeid;
            $lti->timemodified = time();
            $lti->showtitlelaunch = 0;
            $lti->showdescriptionlaunch = 0;

            if (!isset($lti->grade)) {
                $lti->grade = $DB->get_field('lti', 'grade', array('id' => $lti->id));
            }

            if ($lti->instructorchoiceacceptgrades == LTI_SETTING_ALWAYS) {
                lti_grade_item_update($lti);
            } else {
                lti_grade_item_delete($lti);
            }

            $DB->update_record('lti', $lti);
        }
    }

    // Trash modinfo.
    rebuild_course_cache($courseid, true);
}