<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package    local_ltiprocessor
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
defined('MOODLE_INTERNAL') || die();

/**
 * Create LTi's
 *
 * @param string $file filesystem fullpath to target .xls or .xlsx file.
 * @return boolean the Excel file has been successfully imported (true) or no (false).
 */
function local_ltiprocessor_import_runs($courseids, $typeid, $activityname) {
    global $CFG, $DB, $USER;

    if (is_array($courseids) && count($courseids) > 0) {
        foreach ($courseids as $courseid) {
            echo $courseid;
            
            if ($ltiid = $DB->get_field_sql("SELECT id FROM {$CFG->prefix}lti WHERE course = ? AND typeid = ? AND NAME = \"$activityname\"", array($courseid, $typeid))) {
                local_ltiprocessor_update_lti($courseid, $activityname, $typeid, $ltiid);
            } else {
                local_ltiprocessor_create_lti($courseid, $activityname, $typeid);
            }
        }
    }

    // Valid request. Purge, and redirect the user back to where they came from.
    purge_all_caches();
}

// Create Course for each resource
// Create LTi activity with same resource name
// Store custom values in custom table