<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package    local_ltiprocessor
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
require_once(dirname(__FILE__) . '/../../config.php');
require_once($CFG->libdir . '/adminlib.php');
require_once(dirname(__FILE__) . '/mod_form.php');
require_once(dirname(__FILE__) . '/lib.php');
require_once($CFG->dirroot . "/user/lib.php");
require_once($CFG->dirroot . '/user/profile/lib.php');
require_once('locallib.php');

admin_externalpage_setup('local_ltiprocessor_importxml');

$courseid = optional_param('course', 0, PARAM_INT);
$userid = optional_param('userid', 0, PARAM_INT);
$perpage = optional_param('perpage', 30, PARAM_INT);
$process = optional_param('process', null, PARAM_TEXT);

require_login();
require_capability('local/ltiprocessor:manage', context_system::instance());

// Calculate export variables.
$tempdir = 'ltiprocessor';
make_temp_directory($tempdir);

// URL where we'll end, both on success and failure.
$url = new moodle_url('/local/ltiprocessor/index.php');
$successurl = new moodle_url('/local/ltiprocessor/index.php', array('process' => 'success'));
$failureurl = new moodle_url('/local/ltiprocessor/index.php', array('process' => 'failure'));

$strtitle = get_string('importxml', 'local_ltiprocessor');

// Instantiate the import form.
$mform = new local_ltiprocessor_mod_form(null, array());
//$mform->set_data($datarecord);
// If there is any file to import.
if ($data = $mform->get_data()) {
    //try {
        $courseids = $data->courseids;
        $tooltypes = $data->tooltypes;
        $activityname = $data->activityname;

        local_ltiprocessor_import_runs($courseids, $tooltypes, $activityname);
        redirect($successurl);
    /*} catch (moodle_exception $e) {
        echo $e->getMessage();exit;
        redirect($failureurl);
    }*/
}

echo $OUTPUT->header();
echo $OUTPUT->heading($strtitle);

if ($process == 'success') {
    $message = get_string('successmessage', 'local_ltiprocessor');
    echo "<div class='alert alert-info'>$message</div>";
} else if ($process == 'failure') {
    $message = get_string('failuremessage', 'local_ltiprocessor');
    echo "<div class='alert alert-info'>$message</div>";
}

$mform->display();

//$testfilename = 'Bergen_ExcelFormat_V1.0.xlsx'; //Taxonomy_Hurix_V1.0.xlsx'; //Taxonomy_Hurix_V1.0_truefalse.xlsx';
//local_ltiprocessor_import_runs($testfilename);

echo $OUTPUT->footer();
